function edgs = eqpop(X, nb, varargin)

% EQPOP Edges for equipopulated binning
%
% USAGE
% -----
%
%       edgs = eqpop(X, nb)
%
% edgs = eqpop(X, nb) returns the edge values for discretizing all values
% in X into NB equipopulated bins.

%   Copyright (C) 2010 Cesare Magri
%   Version: 1.0.0

% -------
% LICENSE
% -------
% This software is distributed free under the condition that:
%
% 1. it shall not be incorporated in software that is subsequently sold;
%
% 2. the authorship of the software shall be acknowledged and the following
%    article shall be properly cited in any publication that uses results
%    generated by the software:
%
%      Magri C, Whittingstall K, Singh V, Logothetis NK, Panzeri S: A
%      toolbox for the fast information analysis of multiple-site LFP, EEG
%      and spike train recordings. BMC Neuroscience 2009 10(1):81;
%
% 3.  this notice shall remain in place in each source file.

% ----------
% DISCLAIMER
% ----------
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
% IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

uniqueX = unique(X(:));

N = length(uniqueX);
if N<nb
    error('Too many bins for the selected data.');
end;

ValsxBin = floor(N/nb); % Rounded number of values-per-bin
r = N - (ValsxBin*nb);  % Remainder

indx = 1:ValsxBin:ValsxBin*nb;
indx(1:r) = indx(1:r) + (0:(r-1));
indx(r+1:end) = indx(r+1:end) + r;

edgs = zeros(nb+1,1);
edgs(1:nb) = uniqueX(indx);
edgs(nb+1) = uniqueX(end) + 1;